<?php

$CI = get_instance();
$CI->load->database();
$CI->load->dbforge();

// 1. UPDATE VERSION NUMBER INSIDE SETTINGS TABLE
$settings_data = ['value' => '7.0'];
$CI->db->where('key', 'version');
$CI->db->update('settings', $settings_data);

// 2. CREATE TABLE `home_pages` IF NOT EXISTS
$fields = [
    'id'              => ['type' => 'INT', 'constraint' => 11, 'unsigned' => true, 'auto_increment' => true],
    'title'           => ['type' => 'VARCHAR', 'constraint' => '255', 'null' => true],
    'description'     => ['type' => 'TEXT', 'null' => true],
    'identifier'      => ['type' => 'VARCHAR', 'constraint' => '255', 'null' => true],
    'is_permanent'    => ['type' => 'INT', 'constraint' => 11, 'null' => true],
    'status'          => ['type' => 'INT', 'constraint' => 11, 'null' => true],
    'thumbnail'       => ['type' => 'VARCHAR', 'constraint' => '255', 'null' => true],
    'html_file_names' => ['type' => 'TEXT', 'null' => true],
    'created_at'      => ['type' => 'VARCHAR', 'constraint' => '100', 'null' => true],
    'updated_at'      => ['type' => 'VARCHAR', 'constraint' => '100', 'null' => true],
];

if (! $CI->db->table_exists('home_pages')) {
    $CI->dbforge->add_field($fields);
    $CI->dbforge->add_key('id', true);
    $CI->dbforge->create_table('home_pages', true);
}

// 3. INSERT DEFAULT DATA
$default_data = [
    ['title' => 'Learning Platform', 'identifier' => 'startup', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/home_7.png', 'html_file_names' => '["home_7"]'],
    ['title' => 'Cooking', 'identifier' => 'cooking', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/home_6.png', 'html_file_names' => '["home_6"]'],
    ['title' => 'Yoga', 'identifier' => 'yoga', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/home_5.png', 'html_file_names' => '["home_5"]'],
    ['title' => 'Photography', 'identifier' => 'photography', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/home_4.png', 'html_file_names' => '["home_4"]'],
    ['title' => 'Multi Course Selling 2', 'identifier' => 'business', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/home_3.png', 'html_file_names' => '["home_3"]'],
    ['title' => 'Online Coaching', 'identifier' => 'university', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/home_2.png', 'html_file_names' => '["home_2"]'],
    ['title' => 'Multi Course Selling', 'identifier' => 'general', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/home_1.png', 'html_file_names' => '["home_1"]'],
    ['title' => 'Corporate Training', 'identifier' => 'elegant', 'is_permanent' => 1, 'status' => 1, 'thumbnail' => 'assets/frontend/default-new/home/elegant.png', 'html_file_names' => '["home_elegant"]'],
    ['title' => 'Health & Fitness', 'identifier' => 'fitness', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/fitness.png', 'html_file_names' => '["home_fitness"]'],
    ['title' => 'Individual Instructor', 'identifier' => 'kindergarten', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/kindergarten.png', 'html_file_names' => '["home_kindergarten"]'],
    ['title' => 'Online Course Marketplace', 'identifier' => 'marketplace', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/marketplace.png', 'html_file_names' => '["home_marketplace"]'],
    ['title' => 'Tech & Programming', 'identifier' => 'development', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/development.png', 'html_file_names' => '["home_development"]'],
    ['title' => 'University', 'identifier' => 'university2', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/university2.png', 'html_file_names' => '["home_university2"]'],
    ['title' => 'Kids Learning Platform', 'identifier' => 'cooking2', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/cooking2.png', 'html_file_names' => '["home_cooking2"]'],
    ['title' => 'Language Learning', 'identifier' => 'language', 'is_permanent' => 1, 'status' => 0, 'thumbnail' => 'assets/frontend/default-new/home/language.png', 'html_file_names' => '["home_language"]'],
];

foreach ($default_data as $row) {
    // check duplicate to avoid re-insert
    $CI->db->where('html_file_names', $row['html_file_names']);
    $exists = $CI->db->get('home_pages')->row();
    if (! $exists) {
        $CI->db->insert('home_pages', $row);
    }
}

// 4. UPDATE home_pages STATUS BASED ON frontend_settings
$CI->db->where('key', 'home_page');
$query   = $CI->db->get('frontend_settings');
$setting = $query->row();

if (! $setting) {
    return;
}

$selected_home = $setting->value; //'home_1', 'home_2', etc.

// Reset all statuses to 0
$CI->db->update('home_pages', ['status' => 0]);

// Set status = 1 for the selected home page
$CI->db->like('html_file_names', $selected_home);
$CI->db->update('home_pages', ['status' => 1]);
